
/**HEADER********************************************************************
* 
* Copyright (c) 2010 Linear Tech Corporation;
* All Rights Reserved
*
* Copyright (c) 2008 Freescale Semiconductor;
* All Rights Reserved
*
* Copyright (c) 1989-2008 ARC International;
* All Rights Reserved
*
*************************************************************************** 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************
*
* $FileName: cgi-utils.c$
* $Version : 3.0.11.0$
* $Version : Custom for LTC Board Demo Suite
* $Date    : Sep-10-2010$
*
* Comments:
*
*   Example of CGI using RTCS.
*
*END************************************************************************/

//>>>>>>>>>>>>>>>>>>>>>>>>
//cgi-utils.c
//>>>>>>>>>>
//This file contains the utility functions used by the webpages, such as TCP/IP statistics and Real Time Clock data.
//



#include <httpd.h>
#include <cgi.h>
#include <string.h>
#include <bsp.h>               // for LED_BSP
#include <ltctwrutils.h>
//This has the LED declares
#include <main.h>


volatile uint_8 led_status = 0;
extern FILE_PTR output_port;

 HTTPSRV_CGI_RES_STRUCT response;
 char     buffer[100];
 uint_32  ptr;

extern LWGPIO_STRUCT led1;
extern LWGPIO_STRUCT led2;
extern LWGPIO_STRUCT led3;
extern LWGPIO_STRUCT led4;

//extern LWSEM_STRUCT      USB_Stick;
//extern const HTTPD_CGI_LINK_STRUCT cgi_lnk_tbl[];

int pokes = 0;

_mqx_int cgi_rtc_data(HTTPSRV_CGI_REQ_STRUCT *param) {
    #define BUFF_SIZE sizeof("00\n00\n00\n")
    HTTPSRV_CGI_RES_STRUCT response;
    TIME_STRUCT time;
    uint_32 min;
    uint_32 hour;
    uint_32 sec;
    
    char str[BUFF_SIZE];
    uint_32 length = 0;
    
    if (param->request_method != HTTPSRV_REQ_GET)
    {
        return(0);
    }

   
      _time_get(&time);
    sec = time.SECONDS % 60;
    min = time.SECONDS / 60;
    hour = min / 60;
    hour %= 24;
    min %= 60;

    response.ses_handle = param->ses_handle;
    response.content_type = HTTPSRV_CONTENT_TYPE_PLAIN;
    response.status_code = 200;
    /* 
    ** When the keep-alive is used we have to calculate a correct content length
    ** so the receiver knows when to ACK the data and continue with a next request.
    ** Please see RFC2616 section 4.4 for further details.
    */
    
    /* Calculate content length while saving it to buffer */                                  
    length = snprintf(str, BUFF_SIZE, "%ld\n%ld\n%ld\n", hour, min, sec); 
   
    response.data = str;
    response.data_length = length;
    response.content_length = response.data_length;
    /* Send response */
    HTTPSRV_cgi_write(&response);
    return (response.content_length);
 }


//int cgi_ipstat(HTTPD_SESSION_STRUCT *session) {
_mqx_int cgi_ipstat(HTTPSRV_CGI_REQ_STRUCT* param)
{
    HTTPSRV_CGI_RES_STRUCT response;

    if (param->request_method != HTTPSRV_REQ_GET)
    {
        return(0);
    }

    response.ses_handle = param->ses_handle;
    response.content_type = HTTPSRV_CONTENT_TYPE_PLAIN;
    response.status_code = 200;

#if RTCSCFG_ENABLE_IP_STATS && RTCSCFG_ENABLE_IP4
    {
        uint_32 length = 0;
        /* We need to store 10 literals + '\n' (in worst case) for 19 unsigned integers */
        char str[sizeof(char)*19*(10+1)+1];

        /* Read IP statistics */
        IP_STATS_PTR ip = IP_stats();

        /* Print data to buffer */
        length = snprintf(str, sizeof(str),
            "%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n",
            ip->COMMON.ST_RX_TOTAL,
            ip->ST_RX_DELIVERED,
            ip->ST_RX_FORWARDED,
            ip->COMMON.ST_RX_MISSED, 
            ip->COMMON.ST_RX_ERRORS,
            ip->COMMON.ST_RX_DISCARDED,
            ip->ST_RX_HDR_ERRORS,
            ip->ST_RX_ADDR_ERRORS,
            ip->ST_RX_NO_PROTO,
            ip->ST_RX_FRAG_RECVD,
            ip->ST_RX_FRAG_REASMD,
            ip->ST_RX_FRAG_DISCARDED,
            ip->COMMON.ST_TX_TOTAL,
            ip->COMMON.ST_TX_MISSED,
            ip->COMMON.ST_TX_ERRORS,
            ip->COMMON.ST_TX_DISCARDED,
            ip->ST_TX_FRAG_FRAGD,
            ip->ST_TX_FRAG_SENT,
            ip->ST_TX_FRAG_DISCARDED);

        /* Write header and buffer with data */
        
        response.data = str;
        response.data_length = length;
        response.content_length = response.data_length;
        HTTPSRV_cgi_write(&response);
    }
#else
    {
        int i;

        response.content_length = strlen("unk\n")*19;
        response.data = "unk\n";
        response.data_length = 4;
        for (i = 0; i < 19; i++)
        {
            HTTPSRV_cgi_write(&response);
        }
    }
#endif
    return (response.content_length);
}

_mqx_int cgi_icmpstat(HTTPSRV_CGI_REQ_STRUCT* param)
{
    HTTPSRV_CGI_RES_STRUCT response;
    
    if (param->request_method != HTTPSRV_REQ_GET)
    {
        return(0);
    }

    response.ses_handle = param->ses_handle;
    response.content_type = HTTPSRV_CONTENT_TYPE_PLAIN;
    response.status_code = 200;
	
#if RTCSCFG_ENABLE_ICMP_STATS && RTCSCFG_ENABLE_IP4
    {
        uint_32 length = 0;
        char str[sizeof(char)*35*(10+1)];

        ICMP_STATS_PTR icmp = ICMP_stats();

        length = snprintf(str, sizeof(str),
        "%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n",
        icmp->COMMON.ST_RX_TOTAL,
        icmp->COMMON.ST_RX_MISSED,
        icmp->COMMON.ST_RX_ERRORS,
        icmp->COMMON.ST_RX_DISCARDED,
        icmp->ST_RX_BAD_CHECKSUM + icmp->ST_RX_SMALL_DGRAM,
        icmp->ST_RX_BAD_CODE,
        icmp->ST_RX_RD_NOTGATE,
        icmp->COMMON.ST_TX_TOTAL,
        icmp->COMMON.ST_TX_MISSED,
        icmp->COMMON.ST_TX_ERRORS,
        icmp->COMMON.ST_TX_DISCARDED,
        icmp->ST_RX_DESTUNREACH,
        icmp->ST_RX_TIMEEXCEED,
        icmp->ST_RX_PARMPROB,
        icmp->ST_RX_SRCQUENCH,
        icmp->ST_RX_REDIRECT,
        icmp->ST_RX_ECHO_REQ,
        icmp->ST_RX_ECHO_REPLY,
        icmp->ST_RX_TIME_REQ,
        icmp->ST_RX_TIME_REPLY,
        icmp->ST_RX_INFO_REQ,
        icmp->ST_RX_INFO_REPLY,
        icmp->ST_RX_OTHER,
        icmp->ST_TX_DESTUNREACH,
        icmp->ST_TX_TIMEEXCEED,
        icmp->ST_TX_PARMPROB,
        icmp->ST_TX_SRCQUENCH,
        icmp->ST_TX_REDIRECT,
        icmp->ST_TX_ECHO_REQ,
        icmp->ST_TX_ECHO_REPLY,
        icmp->ST_TX_TIME_REQ,
        icmp->ST_TX_TIME_REPLY,
        icmp->ST_TX_INFO_REQ,
        icmp->ST_TX_INFO_REPLY,
        icmp->ST_TX_OTHER);

        /* Write header and buffer with data */
        response.data = str;
        response.data_length = length;
        response.content_length = response.data_length;
        HTTPSRV_cgi_write(&response);
    }
    
#else
    {
        int i;

        response.content_length = strlen("unk\n")*35;
        response.data = "unk\n";
        response.data_length = 4;
        for (i = 0; i < 35; i++)
        {
            HTTPSRV_cgi_write(&response);
        }
    }

#endif
    return (response.content_length);
}
   
_mqx_int cgi_udpstat(HTTPSRV_CGI_REQ_STRUCT* param)
{
    HTTPSRV_CGI_RES_STRUCT response;

    if (param->request_method != HTTPSRV_REQ_GET)
    {
        return(0);
    }

    response.ses_handle = param->ses_handle;
    response.content_type = HTTPSRV_CONTENT_TYPE_PLAIN;
    response.status_code = 200;

#if RTCSCFG_ENABLE_UDP_STATS
    {
        uint_32 length = 0;
        char str[sizeof(char)*10*(10+1)];

        UDP_STATS_PTR udp = UDP_stats();

        length = snprintf(str, sizeof(str),
            "%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n", 
            udp->COMMON.ST_RX_TOTAL,
            udp->COMMON.ST_RX_MISSED,
            udp->COMMON.ST_RX_ERRORS,
            udp->COMMON.ST_RX_DISCARDED,
            udp->ST_RX_BAD_PORT + udp->ST_RX_BAD_CHECKSUM + udp->ST_RX_SMALL_DGRAM + udp->ST_RX_SMALL_PKT,                             
            udp->ST_RX_NO_PORT,
            udp->COMMON.ST_TX_TOTAL,
            udp->COMMON.ST_TX_MISSED,
            udp->COMMON.ST_TX_ERRORS,
            udp->COMMON.ST_TX_DISCARDED);

        /* Write header and buffer with data */
        response.data = str;
        response.data_length = length;
        response.content_length = response.data_length;
        HTTPSRV_cgi_write(&response);  
    }
    
#else
    {
        int i;

        response.content_length = strlen("unk\n")*10;
        response.data = "unk\n";
        response.data_length = 4;
        for (i = 0; i < 10; i++)
        {
            HTTPSRV_cgi_write(&response);
        }
    }

#endif
    return (response.content_length);
}
   
_mqx_int cgi_tcpstat(HTTPSRV_CGI_REQ_STRUCT* param)
{
    HTTPSRV_CGI_RES_STRUCT response;

    if (param->request_method != HTTPSRV_REQ_GET)
    {
        return(0);
    }

    response.ses_handle = param->ses_handle;
    response.content_type = HTTPSRV_CONTENT_TYPE_PLAIN;
    response.status_code = 200;
	
#if RTCSCFG_ENABLE_TCP_STATS
    {
        uint_32 length = 0;
        char str[sizeof(char)*32*(10+1)];
        TCP_STATS_PTR tcp  = TCP_stats();

        length = snprintf(str, sizeof(str), 
            "%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n%ld\n", 
            tcp->COMMON.ST_RX_TOTAL,
            tcp->COMMON.ST_RX_MISSED,
            tcp->COMMON.ST_RX_ERRORS,
            tcp->COMMON.ST_RX_DISCARDED,
            tcp->ST_RX_BAD_PORT + tcp->ST_RX_BAD_CHECKSUM + tcp->ST_RX_SMALL_HDR + tcp->ST_RX_SMALL_DGRAM + tcp->ST_RX_SMALL_PKT,
            tcp->ST_RX_BAD_ACK,
            tcp->ST_RX_BAD_DATA,
            tcp->ST_RX_LATE_DATA,
            tcp->ST_RX_DATA,
            tcp->ST_RX_DATA_DUP,
            tcp->ST_RX_ACK,
            tcp->ST_RX_ACK_DUP,
            tcp->ST_RX_RESET,
            tcp->ST_RX_PROBE,
            tcp->ST_RX_WINDOW,
            tcp->COMMON.ST_TX_TOTAL,
            tcp->COMMON.ST_TX_MISSED,
            tcp->COMMON.ST_TX_ERRORS,
            tcp->COMMON.ST_TX_DISCARDED,
            tcp->ST_TX_DATA,
            tcp->ST_TX_DATA_DUP,
            tcp->ST_TX_ACK,
            tcp->ST_TX_ACK_DELAYED,
            tcp->ST_TX_RESET,
            tcp->ST_TX_PROBE,
            tcp->ST_TX_WINDOW,
            tcp->ST_CONN_ACTIVE,
            tcp->ST_CONN_PASSIVE,
            tcp->ST_CONN_OPEN,
            tcp->ST_CONN_CLOSED,
            tcp->ST_CONN_RESET,
            tcp->ST_CONN_FAILED);

        /* Write header and buffer with data */
        response.data = str;
        response.data_length = length;
        response.content_length = response.data_length;
        HTTPSRV_cgi_write(&response);
    }

#else
    {
        int i;
        
        response.content_length = strlen("unk\n")*32;
        response.data = "unk\n";
        response.data_length = 4;
        for (i = 0; i < 32; i++)
        {
            HTTPSRV_cgi_write(&response);
        }
    }
#endif
    return (response.content_length);
}



_mqx_int cgi_toggle_led1(HTTPSRV_CGI_REQ_STRUCT *param) {
#ifdef BSP_LED1
	led_status ^= 0x01;

	lwgpio_set_value(&led1, (led_status & 0x01) ? LWGPIO_VALUE_HIGH : LWGPIO_VALUE_LOW);

#endif	    
	return (0);
}

_mqx_int cgi_toggle_led2(HTTPSRV_CGI_REQ_STRUCT *session) {
#ifdef BSP_LED2
	led_status ^= 0x02;

	lwgpio_set_value(&led2, (led_status & 0x02) ? LWGPIO_VALUE_HIGH : LWGPIO_VALUE_LOW);

#endif	    
	return (0);
}

_mqx_int cgi_toggle_led3(HTTPSRV_CGI_REQ_STRUCT *session) {
#ifdef BSP_LED3
	led_status ^= 0x04;

	lwgpio_set_value(&led3, (led_status & 0x04) ? LWGPIO_VALUE_HIGH : LWGPIO_VALUE_LOW);

#endif	    
	return (0);
}

_mqx_int cgi_toggle_led4(HTTPSRV_CGI_REQ_STRUCT *session) {
#ifdef BSP_LED4
	led_status ^= 0x08;

	lwgpio_set_value(&led4, (led_status & 0x08) ? LWGPIO_VALUE_HIGH : LWGPIO_VALUE_LOW);

#endif	    
	return (0);
}



_mqx_int cgi_button_1(HTTPSRV_CGI_REQ_STRUCT *session) {
    printf("OK, stop pushing me already...\n");
    pokes++; 	
	return 0;
}

_mqx_int cgi_test_data(HTTPSRV_CGI_REQ_STRUCT *session) {
  
  
	TIME_STRUCT time;
	int min, hour;
	
	_time_get(&time);
	
       
	min = time.SECONDS / 60;
	hour = min / 60;
       	min %= 60;
	
	CGI_SEND_NUM(hour);
	CGI_SEND_NUM(min);
	CGI_SEND_NUM(pokes);
       

	return (response.content_length);
}


_mqx_int cgi_sync_rtc(HTTPSRV_CGI_REQ_STRUCT *param) {
  
    DATE_STRUCT date;
    int_32 Adjustment,  TotAdjustment;
    char     adj_min[15];
    uint_32  len = 0;
    uint_32 update_seconds = 0;
    
    HTTPSRV_CGI_RES_STRUCT response;
    char buffer[10];
    LTCTWR_PARAMS_PTR LTCTWR_Params_Ptr;
    
        LTCTWR_Params_Ptr = LTCTWR_GetParameters();
	len = param->content_length;
    	len = HTTPSRV_cgi_read(param->ses_handle, buffer, len);
    	
        cgi_get_varval( buffer, "secs", adj_min, sizeof(adj_min));
       
        update_seconds = str2int(adj_min) * 60;
       
    
   
        TIME_STRUCT time;
        RTC_TIME_STRUCT time_rtc;
        _time_from_date(&date, &time); 
   
         
       Adjustment = 1356998400;
       TotAdjustment = Adjustment + update_seconds;
       time.SECONDS = TotAdjustment;
       
        
      printf("Adjustment secs after addition: %d \n",TotAdjustment);
      _rtc_time_from_mqx_time(&time,&time_rtc);
      _rtc_set_time (&time_rtc);
      
    
                          response.ses_handle = param->ses_handle;
                          response.content_type = HTTPSRV_CONTENT_TYPE_HTML;
                          response.status_code = 200;
                         
			response.data =	"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">"
			"<html><head><title>MQX</title>"
			"<meta http-equiv=\"REFRESH\" content=\"0;url=rtc.html\"></HEAD>"
			"<BODY></BODY></HTML>";   
			
    		
    response.data_length = strlen(response.data);
    response.content_length = 0;
    HTTPSRV_cgi_write(&response);
    return (response.content_length); 
 }
  
 

_mqx_int cgi_get_varval(char *var_str, char *var_name, char *var_val, _mqx_int var_val_len)
{
    char *var = var_str;
    int res = 0;
    int idx;

    var_val[0] = 0;

    while ((var = strstr(var, var_name)) != 0)
    {
        if (*(var + strlen(var_name)) == '=')
        {
            var += strlen(var_name) + 1;    // +1 because '='

            idx = (int)strcspn(var, "&");
            strncpy(var_val, var, (unsigned long)idx);
            var_val[idx] = 0;
            res = 1;
            break;
        }
        else
        {
            var = strchr(var, '&');
        }
    }

    return res;
}






